//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk.state](../index.md)/[OnlineStatus](index.md)

# OnlineStatus

[common]\
enum [OnlineStatus](index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[OnlineStatus](index.md)&gt; 

A User's online status in this Chat silo

## Entries

| | |
|---|---|
| [Online](-online/index.md) | [common]<br>[Online](-online/index.md)<br>Actively available. The suggests a near immediate response |
| [Offline](-offline/index.md) | [common]<br>[Offline](-offline/index.md)<br>The user is not connected to the network. This suggests an entirely random response time |
| [Away](-away/index.md) | [common]<br>[Away](-away/index.md)<br>A user that is connected to the network but is &quot;Away&quot;. This suggests a likely response in the near future |
| [DND](-d-n-d/index.md) | [common]<br>[DND](-d-n-d/index.md)<br>A user that has explicitely marked their Chat availbility as Do Not Disturb. The user is actively connected to the network and would like his peers to know he is connect4ed, but does not wish to receive any messages. |
| [Unknown](-unknown/index.md) | [common]<br>[Unknown](-unknown/index.md) |

## Properties

| Name | Summary |
|---|---|
| [entries](entries.md) | [common]<br>val [entries](entries.md): [EnumEntries](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.enums/-enum-entries/index.html)&lt;[OnlineStatus](index.md)&gt;<br>Returns a representation of an immutable list of all enum entries, in the order they're declared. |

## Functions

| Name | Summary |
|---|---|
| [valueOf](value-of.md) | [common]<br>fun [valueOf](value-of.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [OnlineStatus](index.md)<br>Returns the enum constant of this type with the specified name. The string must match exactly an identifier used to declare an enum constant in this type. (Extraneous whitespace characters are not permitted.) |
| [values](values.md) | [common]<br>fun [values](values.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[OnlineStatus](index.md)&gt;<br>Returns an array containing the constants of this enum type, in the order they're declared. |
